/*
 * mreport.h
 *	Jason Armstrong <jason@datrix.co.za>
 *
 * $Id: mreport.h,v 1.12 2000/01/25 09:14:18 jason Exp $
 */

#ifndef _MREPORT_H_
#define _MREPORT_H_

#define M_VERSION	"0.9"
#define M_DEVELOPER	"Jason Armstrong"

#define FROM		"from="
#define SIZE		"size="
#define TO		"to="
#define CTL		"ctladdr="
#define NRCPTS		"nrcpts="
#define DELAY		"delay="
#define STAT		"stat="

#define DEFERRED	"Deferred"
#define HOST_UNKNOWN	"Host unknown"
#define USER_UNKNOWN	"User unknown"
#define EOM_ERROR	"premature EOM"
#define IO_ERROR	"I/O error"
#define NO_SERVICE	"Service unavailable"
#define OWNER		"owner="
#define CLONE		"clone"
#define SENT		"Sent"
#define QUEUED		"queued"
#define RULESET		"ruleset="
#define NORELAY		"we do not relay"
#define LOSTINPUT	"lost input channel"
#define RETURN		"return to sender"
#define DSN		"DSN"
#define SYSERR		"SYSERR"

#define DEFAULT_MAILLOG	"/var/log/maillog"
#define DEFAULT_NICE	0
#define DEFAULT_BIG	500000

#define M_ALIAS		"alias"
#define M_LOGIN		"Login"
#define M_LOGOUT	"Logout"
#define M_DAEMON	"starting daemon"

#define M_MARGIN	5000
#define M_INCREMENT	50
#define M_BUFSIZE	512
#define M_UNKNOWN	"UNKNOWN"
#define MAX_REACHED	2
#define M_STATUS	50
#define M_KEYSIZE	256
#define M_NO_RELAY	2
#define M_NO_USER	3

#define DBG(x)	if (o->dbg) { printf("%s\n", x); fflush(stdout); }

struct options {
	char prog[32];
	char machine[64];
	char config[256];

	char in[256];
	char out[256];
	char aliases[256];

	char string[64];
	char string2[64];
	int str;

	char exclude[64];
	int ex;

	int from;
	int to;

	int dbg;
	int nice;
	int order;
	int max;
	int big;
	char domain[64];
	int dom;
	int summary;
	int timer;
	int showerrs;
	int nostats;
	int alias;
};

struct from {
	char email[200];
	unsigned long size;
	int nrcpts;
};

struct to {
	char email[200];
	char ctrl[200];
	char stat[32];
	int status;
};

struct final {
	char from[200];
	char to[200];
	unsigned long size;
	int num;
};

struct m_errors {
	int deferred;
	int hostunknown;
	int userunknown;
	int ioerror;
	int eomerror;
	int noservice;
	int norelay;
};

struct errinfo {
	char from[200];
	char to[200];
	char stat[32];
	int num;
};

struct duplicate {
	char id1[16];
	char id2[16];
};

struct alias {
	char account[128];
	char alias[128];
};

struct data {
	FILE *in;
	FILE *out;

	char first[17];
	char last[17];

	unsigned long total;
	char id[16];

	int duplicate;
	struct duplicate **dup;
	int dupi;
	int dupcount;

	struct from mfrom;
	struct from **from;
	int fromi;
	int fromcount;

	struct to mto;
	struct to **to;
	int toi;
	int tocount;

	char *mbuf;
	int mbufsize;

	char **keys;
	int keyi;
	int keycount;

	char **keysto;
	int keytoi;
	int keytocount;

	struct hash *hfrom;
	struct hash *hto;
	struct hash *halias;

	struct final **mfinal;
	int finali;
	int finalcount;

	struct errinfo **merrinfo;
	int erri;
	int errcount;

	struct m_errors merrs;

	struct alias **al;
	int ali;
	int alcount;
};

int m_init(struct options *o, struct data *d);
int m_load_aliases(struct options *o, struct data *d);
int m_process_alias(struct options *o, struct data *d, char *buf);
int m_add_alias(struct options *o, struct data *d, char *account, char *alias);
int m_check_alias(struct options *o, struct data *d);
int m_getdata(struct options *o);
int m_getline(struct options *o, struct data *d);

int m_getid(struct options *o, char *id, int size, char *buf);
int m_add_from(struct options *o, struct data *d, char **p);
int m_get_from_email(struct options *o, char **p, char *email, int size);
int m_get_from_size(struct options *o, char *p, unsigned long *size);
int m_get_nrcpts(struct options *o, struct data *d);

int m_process_stat(struct options *o, struct data *d, char **p);
int m_get_stat(struct options *o, struct data *d, char *p);
int m_get_ctrl(struct options *o, struct data *d);
int m_get_to(struct options *o, struct data *d);
int m_add_to(struct options *o, struct data *d);

int m_last_resort(struct options *o, struct data *d);
int m_add_problem(struct options *o, struct data *d, int flag);
int m_get_clone_id(struct options *o, struct data *d, char *p);

int m_report(struct options *o, struct data *d);
int m_get_final(struct options *o, struct data *d);
int m_add_final(struct options *o, struct data *d, void *from, void *to);
int m_add_error(struct options *o, struct data *d, void *from, void *to);

int m_sort(struct options *o, struct data *d);
int m_cmpnum(const void *n1, const void *n2);
int m_cmpsize(const void *s1, const void *s2);
int m_cmpemailfrom(const void *s1, const void *s2);
int m_cmpemailto(const void *s1, const void *s2);
int m_cmperrs(const void *s1, const void *s2);

int m_getconfig(struct options *o, int ac, char *av[]);
int m_checkopt(struct options *o);

int m_register_duplicate(struct options *o, struct data *d);
int m_lookup_duplicate(struct options *o, struct data *d);

int m_print_output(struct options *o, struct data *d);
int m_show_errors(struct options *o, struct data *d);
int m_show_stats(struct options *o, struct data *d);
int m_errs_summary(struct data *d, int n, int *l, char *s);

int m_checkstring(struct options *o, char *from, char *to);
int m_get_email(char *str, char *email, int size);
int m_corruptline(struct options *o, char *buf);

int m_err(int line, char *s, char *err);
void usage(char *progname);
void version(char *progname);


#endif /* _MREPORT_H_ */

